<?php

if($_SESSION["perfil"] == "Invitado"){

  echo '<script>

    window.location = "inicio";

  </script>';

  return;

}

?>

<div class="content-wrapper">

  <section class="content-header">

    <h1>

      Administrar servicios

    </h1>

    <ol class="breadcrumb">

      <li><a href="inicio"><i class="fa fa-dashboard"></i> Inicio</a></li>

      <li class="active">Administrar servicios</li>

    </ol>

  </section>

  <section class="content">

    <div class="box">

      <div class="box-header with-border">

        <button class="btn btn-primary" data-toggle="modal" data-target="#modalAgregarServicio">

          Nuevo servicio

        </button>

      </div>

      <div class="box-body">

       <table class="table table-bordered table-striped dt-responsive tablas" width="100%">

        <thead>

         <tr>

           <th style="width:10px">#</th>
           <th>Tipo de servicio</th>
           <th>Descripción del servicio</th>
           <th>Cantidad de Bolsa</th>
           <th>Valor de Servicio</th>
           <th>Fecha Creada</th>
           <th>Estado</th>
           <th>Acciones</th>

         </tr>

        </thead>

        <tbody>
          <?php

          $item = null;
          $valor = null;

          $personas = ControladorServicios::ctrMostrarServicios($item, $valor);

          foreach ($personas as $key => $value) {


            echo '<tr>

                    <td>'.($key+1).'</td>


                    <td>'.$value["descripcion"].'</td>

                    <td>'.$value["nombre"].'</td>

                    <td>'.$value["cantidad_bolsa"].'</td>

                    <td>'.$value["valor_servicio"].'</td>

                    <td>'.$value["fecha"].'</td>';

                    if($value["estado"] == 'activo'){

                        echo '<td><span class="btn btn-success btn-xs btnActivar" idServicio="'.$value["idtipo_servicios"].'" estadoServicio="inactivo">Activado</span></td>';

                    } else {

                        echo '<td><span class="btn btn-danger btn-xs btnActivar" idServicio="'.$value["idtipo_servicios"].'" estadoServicio="activo">Desactivado</span></td>';

                    }



                    echo '<td>

                      <div>

                        <button class="btn btn-warning btnEditarServicio" data-toggle="modal" data-target="#modalEditarServicio" idtipo_servicios="'.$value["idtipo_servicios"].'"><i class="fa fa-pencil"></i></button>';

                      if($_SESSION["perfil"] == "Administrador"){

                          echo ' <button class="btn btn-danger btnEliminarServicio" idtipo_servicios="'.$value["idtipo_servicios"].'"><i class="fa fa-trash"></i></button>';

                      }


                      echo '</div>

                    </td>

                  </tr>';

            }

        ?>

        </tbody>

       </table>

      </div>

    </div>

  </section>

</div>

<!--=====================================
MODAL AGREGAR SERVICIO
======================================-->

<div id="modalAgregarServicio" class="modal fade" role="dialog">

  <div class="modal-dialog">

    <div class="modal-content">

      <form role="form" method="post">

        <!--=====================================
        CABEZA DEL MODAL
        ======================================-->

        <div class="modal-header" style="background:#3c8dbc; color:white">

          <button type="button" class="close" data-dismiss="modal">&times;</button>

          <h4 class="modal-title">Agregar servicio</h4>

        </div>

        <!--=====================================
        CUERPO DEL MODAL
        ======================================-->

        <div class="modal-body" style="padding:0px">

          <div class="box-body" style="padding:0px">


                  <div class="form-row">

                    <div class="form-group col-md-6">
                      <label for="inputCity">Tipo de Servicio:</label>
                      <div class="input-group">
                      <span class="input-group-addon"><i class="fa fa-audio-description"></i></span>
                      <select class="form-control" id="nuevoTipoServicio" name="nuevoTipoServicio" required>
                              <option value="">Seleccione</option>
                              <option value="Comercio">Comercio</option>
                              <option value="Domiciliar">Domiciliar</option>

                            </select>
                      </div>
                    </div>

                    <div class="form-group col-md-6">
                      <label for="inputCity">Descripción servicio:</label>
                      <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-american-sign-language-interpreting"></i></span>

                        <input type="text" class="form-control" name="nuevoNombreServicio" placeholder="Nombre del servicio" required>
                      </div>
                    </div>



                  </div>

                  <!-- ENTRADA PARA EL NOMBRE -->

                  <div class="form-row">

                    <div class="form-group col-md-6">
                      <label for="inputCity">Cantidad de Bolsas:</label>
                      <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-list-ol"></i></span>
                        <input type="number" min="0" class="form-control" name="nuevoCatidadBolsas" placeholder="Cantidad de Bolsas" required>
                      </div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="inputCity">Valor del Servicio:</label>
                        <div class="input-group">
                          <span class="input-group-addon"><i class="fa fa-usd"></i></span>
                          <input type="text" class="form-control" name="nuevoValorServicio" placeholder="Valor del Servicio" required>
                        </div>
                      </div>

                  </div>
        </div>
    </div>

        <!--=====================================
        PIE DEL MODAL
        ======================================-->

        <div class="modal-footer">

          <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-arrow-circle-left"></i> Cancelar</button>

          <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Guardar</button>

        </div>

      </form>

      <?php

        $crearServicio = new ControladorServicios();
        $crearServicio -> ctrCrearServicio();

      ?>

    </div>

  </div>

</div>

<!--=====================================
MODAL EDITAR SERVICIO
======================================-->
<div id="modalEditarServicio" class="modal fade" role="dialog">

  <div class="modal-dialog">

    <div class="modal-content">

      <form role="form" method="post">

        <!--=====================================
        CABEZA DEL MODAL
        ======================================-->

        <div class="modal-header" style="background:#3c8dbc; color:white">

          <button type="button" class="close" data-dismiss="modal">&times;</button>

          <h4 class="modal-title">Editar Servicio</h4>

        </div>

        <!--=====================================
        CUERPO DEL MODAL
        ======================================-->

        <div class="modal-body" style="padding:0px">

          <div class="box-body" style="padding:0px">

                  <!-- ENTRADA PARA EL NOMBRE -->

                  <div class="form-row">

                    <div class="form-group col-md-6">
                      <label for="inputCity">Tipo de Servicio:</label>
                      <div class="input-group">
                      <span class="input-group-addon"><i class="fa fa-audio-description"></i></span>
                      <select class="form-control" name="editarTipoServicio" required>
                              <option value="" id="editarTipoServicio">Seleccione</option>
                              <option value="Comercio">Comercio</option>
                              <option value="Domiciliar">Domiciliar</option>

                            </select>
                      </div>
                    </div>

                    <div class="form-group col-md-6">
                      <label for="inputCity">Descripción del servicio:</label>
                      <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-american-sign-language-interpreting"></i></span>
                        <input type="hidden" class="form-control" id="idtipo_servicios" name="idtipo_servicios">
                        <input type="text" class="form-control" id="editarNombreServicio" name="editarNombreServicio" placeholder="Nombre del servicio" required>
                      </div>
                    </div>

                  </div>

                  <!-- ENTRADA PARA EL NOMBRE -->

                  <div class="form-row">

                    <div class="form-group col-md-6">
                      <label for="inputCity">Cantidad de Bolsas:</label>
                      <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-list-ol"></i></span>
                        <input type="number" min="0" class="form-control" id="editarCatidadBolsas" name="editarCatidadBolsas" placeholder="Cantidad de Bolsas" required>
                      </div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="inputCity">Valor del Servicio:</label>
                        <div class="input-group">
                          <span class="input-group-addon"><i class="fa fa-usd"></i></span>
                          <input type="text" class="form-control" id="editarValorServicio" name="editarValorServicio" placeholder="Valor del Servicio" required>
                        </div>
                      </div>

                  </div>



        </div>
    </div>

        <!--=====================================
        PIE DEL MODAL
        ======================================-->

        <div class="modal-footer">

          <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-arrow-circle-left"></i> Cancelar</button>

          <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Guardar cambios</button>

        </div>

      </form>

        <?php

        $editarPersona = new ControladorServicios();
        $editarPersona -> ctrEditarServicio();

      ?>



    </div>

  </div>

</div>

<?php

  $eliminarPersona = new ControladorServicios();
  $eliminarPersona -> ctrEliminarServicio();

?>

<script>
/*=============================================
ACTIVAR PERSONA
=============================================*/
$(document).on("click", ".btnActivar", function(){

  var idServicio = $(this).attr("idServicio");
  var estadoServicio = $(this).attr("estadoServicio");

  var datos = new FormData();
   datos.append("activarId", idServicio);
    datos.append("activarServicio", estadoServicio);

    $.ajax({

    url:"ajax/servicios.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
      contentType: false,
      processData: false,
      success: function(respuesta){

          if(window.matchMedia("(max-width:767px)").matches){

             swal({
            title: "Servicio ha sido actualizado",
            type: "success",
            confirmButtonText: "¡Cerrar!"
          }).then(function(result) {
              if (result.value) {

                window.location = "servicios";

              }


        });

          }

      }

    })

    if(estadoServicio == 'inactivo'){

      $(this).removeClass('btn-success');
      $(this).addClass('btn-danger');
      $(this).html('Desactivado');
      $(this).attr('estadoPersona','inactivo');

    }else{

      $(this).addClass('btn-success');
      $(this).removeClass('btn-danger');
      $(this).html('Activado');
      $(this).attr('estadoUsuario','activo');

    }

  })
</script>
